# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac

CliSave.GlobalConfigMode.addCommandSequence( 'Power.global' )
CliSave.GlobalConfigMode.addCommandSequence( 'PowerController.global' )

@CliSave.saver( 'Hardware::PowerSupply::CliConfig',
                'hardware/powerSupply/config/cli' )
def savePowerSupplyConfig( entity, root, requireMounts, options ):
   cmds = root[ 'Power.global' ]

   if entity.pollInterval != entity.defaultPollInterval or \
         options.saveAll:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'power poll-interval %d' % ( entity.pollInterval ) )

   defaultPowerCurrentLimit = Tac.Value( "Units::Amps" ).value
   if entity.currentLimit != defaultPowerCurrentLimit:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'power limit current %.1f amps' % ( entity.currentLimit ) )
   elif options.saveAll:
      cmds.addCommand( 'no power limit current' )

   defaultColdRedundancyConfig = False
   if entity.coldRedundancyEnabled != defaultColdRedundancyConfig:
      cmds.addCommand( 'power redundancy cold' )
   elif options.saveAll:
      cmds.addCommand( 'no power redundancy cold' )

@CliSave.saver( 'Hardware::PowerController::CliConfig',
                'hardware/powercontroller/cliconfig' )
def savePowerControllerPollInterval( entity, root, requireMounts, options ):
   cmds = root[ 'PowerController.global' ]

   if options.saveAll or ( entity.pollInterval != entity.defaultPollInterval ):
      if entity.pollInterval.is_integer():
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( "environment power controller poll-interval %d seconds" %
                          entity.pollInterval )
      else:
         cmds.addCommand(
            # pylint: disable-next=consider-using-f-string
            "environment power controller poll-interval %d milliseconds" %
            ( 1000 * entity.pollInterval ) )
