# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Power.global' )

@CliSave.saver( 'PowerManager::PowerManagerCliConfig',
                'environment/archer/power/config/powerManagerCliConfig',
                requireMounts=( 'environment/archer/power/config/powerManager', ) )
def savePowerManager( entity, root, requireMounts, options ):
   cmds = root[ 'Power.global' ]

   if entity.powerBudget != float( "inf" ):
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'power budget %d watts' % ( entity.powerBudget ) )
   elif entity.powerBudget == float( "inf" ) and options.saveAll:
      cmds.addCommand( 'no power budget' )
   if entity.mode == 'warn':
      cmds.addCommand( 'power budget exceeded action warn' )
   elif entity.mode == 'strict' and options.saveAll:
      cmds.addCommand( 'power budget exceeded action hold-down' )
   if entity.modularMode == 'warn':
      cmds.addCommand( 'environment insufficient-power action ignore' )
   elif entity.modularMode == 'strict' and options.saveAll:
      cmds.addCommand( 'environment insufficient-power action shutdown' )

   pmConfig = requireMounts[ 'environment/archer/power/config/powerManager' ]
   if entity.splitDomainMode:
      cmds.addCommand( 'power domain split' )
   elif len( pmConfig.powerDomain ) > 1 and not entity.splitDomainMode and \
         options.saveAll:
      cmds.addCommand( 'no power domain split' )

@CliSave.saver( 'Hardware::PowerSupply::CliConfig',
                'hardware/powerSupply/config/cli' )
def savePowerThreshold( entity, root, requireMounts, options ):
   cmds = root[ 'Power.global' ]
   if entity.powerThreshold != float( "inf" ):
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'power threshold %d watts' % ( entity.powerThreshold ) )
   elif entity.powerThreshold == float( "inf" ) and options.saveAll:
      cmds.addCommand( 'no power threshold' )
