# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode

from CliMode.IcmpProbe import IcmpProbeBaseMode
from Toggles.IcmpResponderToggleLib import toggleIcmpProbeResponderEnabled

class IcmpProbeConfigMode( IcmpProbeBaseMode, CliSave.Mode ):
   def __init__( self, param ):
      IcmpProbeBaseMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

RouterGeneralCliSaveMode.addChildMode( IcmpProbeConfigMode )
IcmpProbeConfigMode.addCommandSequence( 'icmpprobe.config' )

@CliSave.saver( 'IcmpResponder::ProbeResponder::Config', 'icmp/probe/config' )
def saveIcmpProbeConfig( entity, root, requireMounts, options ):
   if not toggleIcmpProbeResponderEnabled():
      return

   saveAll = options.saveAll

   # See BUG944856: this should change to getSingletonInstance when
   # all the other callers do.
   parentMode = root[ RouterGeneralCliSaveMode ].getSingletonInstance()
   mode = parentMode[ IcmpProbeConfigMode ].getSingletonInstance()
   cmds = mode[ 'icmpprobe.config' ]
   if entity.enabled:
      cmds.addCommand( 'probe vrf default' )
   elif saveAll:
      cmds.addCommand( 'no probe vrf default' )
   queryTypes = ( entity.allowIfname, entity.allowIfindex,
                  entity.allowAddr, entity.allowRemote )
   if queryTypes == ( True, True, True, True ):
      cmds.addCommand( 'query-types all' )
   elif queryTypes != ( False, False, False, False ):
      enabled = [ kw
                  for i, kw in enumerate( [ 'ifname', 'ifindex',
                                            'addr', 'remote' ] )
                  if queryTypes[ i ] ]
      cmds.addCommand( f'query-types {" ".join( enabled )}' )
   elif saveAll:
      cmds.addCommand( 'no query-types' )
