# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'PtpTimeSync.cliConfig' )

@CliSave.saver( 'PtpTimeSync::CliConfig', 'ptpTimeSync/cliConfig',
                requireMounts = ( 'ptpTimeSync/config',
                                  'ptpTimeSync/stateConfig', ) )
def savePtpTimeSyncConfig( entity, root, requireMounts, options ):

   cmds = root[ 'PtpTimeSync.cliConfig' ]
   supported = requireMounts[ 'ptpTimeSync/config' ].supported

   if ( entity.heartbeatInterval != entity.defaultHeartbeatInterval or
        options.saveAll and supported ):
      cmds.addCommand( 'ptp hardware-sync interval %d' % entity.heartbeatInterval )
   if ( entity.timeScale != 'tai' or options.saveAll and supported ):
      cmds.addCommand( 'mac timestamp scale %s' % entity.timeScale )

