# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Ark
import Toggles.StorageDevicesToggleLib as StorageDevicesToggles

factoryResetCliEnabled = \
   StorageDevicesToggles.toggleStorageDevicesFactoryResetCliEnabled()

# BUG901805: tracking replacing hardcoded list of platform
pushButtonRecoverySupportedPlat = { "councilbluffs", "independence",
                                    "prairieisland", "raspberryisland", "wh3p" }

CliSave.GlobalConfigMode.addCommandSequence( 'StorageDevices.pushButtonConfig' )

@CliSave.saver( 'StorageDevices::PushButtonRecoveryCliConfig',
                'hardware/pushButton/cliConfig' )
def savePushButtonRecoveryCliConfig( entity, root, _, options ):
   if not factoryResetCliEnabled:
      return
   if Ark.getPlatform() not in pushButtonRecoverySupportedPlat:
      return
   cmds = root[ 'StorageDevices.pushButtonConfig' ]
   if not entity.recoveryEnabled:
      cmds.addCommand( 'reset system storage push-button disabled' )
   else:
      if options.saveAll:
         cmds.addCommand( 'default reset system storage push-button' )
