#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Reflector import ReflectorModeBase, ReflectorInterfaceModeBase
from ReflectorTypes import ( tacReflectorMacAction, tacReflectorDirection,
                             directionToString, macActionToString )

class ReflectorConfigMode( ReflectorModeBase, CliSave.Mode ):
   def __init__( self, param ):
      ReflectorModeBase.__init__( self )
      CliSave.Mode.__init__( self, self.longModeKey )

   def skipIfEmpty( self ):
      return True

class ReflectorInterfaceConfigMode( ReflectorInterfaceModeBase, CliSave.Mode ):
   def __init__( self, param ):
      ReflectorInterfaceModeBase.__init__( self, param.toStrep() )
      CliSave.Mode.__init__( self, self.longModeKey )

CliSave.GlobalConfigMode.addCommandSequence( 'Reflector.config' )
CliSave.GlobalConfigMode.addChildMode( ReflectorConfigMode )

ReflectorConfigMode.addChildMode( ReflectorInterfaceConfigMode )
ReflectorInterfaceConfigMode.addCommandSequence( 'Reflector.interface' )

@CliSave.saver( 'Reflector::Config', 'reflector/cliConfig' )
def saveConfig( entity, root, requireMounts, options ):
   saveAll = options.saveAll
   reflectorMode = root[ ReflectorConfigMode ].getSingletonInstance()

   def addCommandReflectorInterface( key ):
      reflectorInterfaceMode = reflectorMode[ ReflectorInterfaceConfigMode ].\
                               getOrCreateModeInstance( key )
      reflectorInterface = entity.interfaceConfig[ key ]
      cmdList = []
      if reflectorInterface:
         if reflectorInterface.direction != tacReflectorDirection.directionNone:
            cmdList.append( "direction %s" # pylint: disable=consider-using-f-string
                            % directionToString[ reflectorInterface.direction ] )
         elif saveAll:
            cmdList.append( "default direction" )

         if reflectorInterface.macAction != tacReflectorMacAction.macActionNone:
            cmdList.append( "mac %s" # pylint: disable=consider-using-f-string
                            % macActionToString[ reflectorInterface.macAction ] )
         elif saveAll:
            cmdList.append( "default mac" )

         cmdSeq = reflectorInterfaceMode[ 'Reflector.interface' ]
         for cmd in cmdList:
            cmdSeq.addCommand( cmd )

   reflectorInterfaceConfig = entity.interfaceConfig
   for key in sorted( reflectorInterfaceConfig ):
      addCommandReflectorInterface( key )
