# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode

@CliSave.saver( 'Routing::RouteMap::Config', 'routing/routemap/config' )
def saveCommandRouteMapPolicyReferUnconfigError( entity, root, requireMounts,
                                                 options ):
   saveAll = options.saveAll
   mode = root[ RouterGeneralCliSaveMode ].getSingletonInstance()
   cmds = mode[ 'config' ]

   cmdStr = 'command route-map policy reference unconfigured action error'
   if entity.routeMapPolicyReferenceUnconfiguredError:
      cmds.addCommand( cmdStr )
   elif saveAll:
      cmds.addCommand( "no " + cmdStr )

@CliSave.saver( 'Routing::RouteMap::Config', 'routing/routemap/config' )
def saveCommandRouteMapPriority( entity, root, sysdbRoot, options ):

   saveAll = options.saveAll

   mode = root[ RouterGeneralCliSaveMode ].getSingletonInstance()
   cmds = mode[ 'config' ]
   # pylint: disable-next=consider-using-f-string
   if ( entity.routeMapSourcePriority != entity.routeMapSourcePriorityDefault or
        saveAll ):
      cmds.addCommand( 'route-map source cli priority '
                       f'{entity.routeMapSourcePriority}' )
