# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Snmp.routing',
      after=[ 'Snmp.global' ] )

@CliSave.saver( 'Routing::SnmpConfig', 'routing/snmpConfig' )
def saveRoutingTable( entity, root, requireMounts, options ):
   # Note that, as a hidden command, we don't output it in "all" or "detail" modes.
   if not entity.enabled:
      root[ 'Snmp.routing' ].addCommand( 'no snmp-server routing-mibs' )
   if entity.pingTime != entity.pingTimeDefault or \
         entity.restartTime != entity.restartTimeDefault:
      cmd = 'snmp-server routing-mibs timers %d %d' % \
                                 ( entity.pingTime, entity.restartTime )
      root[ 'Snmp.routing' ].addCommand( cmd )

