# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliMode.ServerProbe import MonitorServerBaseMode
from CliSavePlugin.Security import mgmtSecurityConfigPath
import CliSave
from CliSave import escapeFormatString
import ReversibleSecretCli
import Tac

class MonitorServerConfigMode( MonitorServerBaseMode, CliSave.Mode ):
   def __init__( self, param ):
      MonitorServerBaseMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( MonitorServerConfigMode )
MonitorServerConfigMode.addCommandSequence( 'ServerProbe.config' )

def saveProtocolConfig( protocol, protocolConfig, root, config, options,
      requireMounts ):
   secretConfig = requireMounts[ mgmtSecurityConfigPath ]
   protocolConfigMode = root[ MonitorServerConfigMode ].getOrCreateModeInstance(
         protocol )
   cmds = protocolConfigMode[ 'ServerProbe.config' ]

   if protocolConfig.serviceList:
      for service in protocolConfig.serviceList:
         cmds.addCommand( 'service %s' % service )
   elif options.saveAll:
      cmds.addCommand( 'no service dot1x' )

   if protocolConfig.interval != protocolConfig.defaultInterval:
      cmds.addCommand( 'probe interval %d seconds' % protocolConfig.interval )
   elif options.saveAll:
      cmds.addCommand( 'no probe interval' )

   if protocolConfig.failCount != protocolConfig.defaultFailCount:
      cmds.addCommand( 'probe threshold failure %d' % protocolConfig.failCount )
   elif options.saveAll:
      cmds.addCommand( 'no probe threshold failure' )

   if protocolConfig.protocol == 'radius':
      if protocolConfig.probeMethod == 'radiusAccessRequest':
         username = protocolConfig.radiusAccessRequestKey.username
         password = protocolConfig.radiusAccessRequestKey.password
         formatStr = ( 'probe method access-request username '
                       f'{escapeFormatString( username )} password {{}}' )
         cmds.addCommand( ReversibleSecretCli.getCliSaveCommand( formatStr,
                                                                 secretConfig,
                                                                 password ) )
      elif options.saveAll:
         cmds.addCommand( 'probe method status-server' )

@CliSave.saver( 'ServerProbe::Config', 'serverProbe/config',
      requireMounts=( mgmtSecurityConfigPath, ) )
def saveConfig( entity, root, requireMounts, options ):
   # Save protocol configs
   for protocol in entity.protocolConfig:
      saveProtocolConfig( protocol, entity.protocolConfig[ protocol ], root,
         entity, options, requireMounts )
