#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.EtbaCliSave import PlatformTfaCliSaveMode

PlatformTfaCliSaveMode.addCommandSequence( 'poMemberIntfHwOffload' )

@CliSave.saver( 'Bridging::Etba::CliConfig', 'bridging/etba/cli/config' )
def saveFlowTrackingSampledHwOffloadlagMember( entity, root, requireMounts,
                                               options ):
   mode = root[ PlatformTfaCliSaveMode ].getSingletonInstance()
   cmds = mode[ 'poMemberIntfHwOffload' ]
   if entity.poMemberIntfHwOffload:
      cmds.addCommand( 'flow tracking sampled hardware offload lag member' )
   elif options.saveAll:
      cmds.addCommand( 'no flow tracking sampled hardware offload lag member' )
