# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.SsdpMode import SsdpMode, SsdpVrfMode
from CliSavePlugin.UpnpCliSave import UpnpCliSaveMode
from CliSavePlugin import IntfCliSave
import CliSave
import Tac

class SsdpCliSaveMode( SsdpMode, CliSave.Mode ):
   def __init__( self, param ):
      SsdpMode.__init__( self )
      CliSave.Mode.__init__( self, param )

class SsdpVrfCliSaveMode( SsdpVrfMode, CliSave.Mode ):
   def __init__( self, param ):
      SsdpVrfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

UpnpCliSaveMode.addCommandSequence( 'Upnp.global' )
CliSave.GlobalConfigMode.addChildMode( UpnpCliSaveMode )

SsdpCliSaveMode.addCommandSequence( 'Ssdp.common' )
UpnpCliSaveMode.addChildMode( SsdpCliSaveMode, after=[ 'Upnp.global' ] )

SsdpVrfCliSaveMode.addCommandSequence( 'Ssdp.vrfConfig' )
SsdpCliSaveMode.addChildMode( SsdpVrfCliSaveMode, after=[ 'Ssdp.common' ] )

IntfCliSave.IntfConfigMode.addCommandSequence( 'Ssdp.Config' )

@CliSave.saver( 'Ssdp::Config', 'upnp/ssdp/config' )
def saveSsdpConfig( entity, root, requireMounts, options ):
   # UPNP global commands
   upnpMode = root[ UpnpCliSaveMode ].getOrCreateModeInstance( param=None )

   ssdpMode = upnpMode[ SsdpCliSaveMode ].getOrCreateModeInstance( param=None )

   # SSDP Vrf configuration
   for vrfName, vrfCfg in entity.vrfConfig.items():
      ssdpVrfMode = \
            ssdpMode[ SsdpVrfCliSaveMode ].getOrCreateModeInstance( param=vrfName )
      ssdpVrfCmds = ssdpVrfMode[ 'Ssdp.vrfConfig' ]
      if vrfCfg.serverState != "enabled":
         ssdpVrfCmds.addCommand( "disabled" )

   # SSDP interface configuration
   for intfName in entity.interface:
      intfMode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(
         intfName )
      intfCmds = intfMode[ 'Ssdp.Config' ]
      intfCmds.addCommand( 'ip ssdp' )
