#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( "Stage.blockStage" )

@CliSave.saver( "Stage::StageGlobalConfig", "stage/stageGlobalConfig" )
def saveStageGlobalConfig( entity, root, requireMounts, options ):
   #-------------------------------------------------------------------------
   # stage-config <stageClass> block <stage>
   #-------------------------------------------------------------------------
   cmds = root[ "Stage.blockStage" ]
   for stageInfo, delay in entity.doNotStartStage.items():
      if delay:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( "stage-config %s block %s %d seconds" % (
               stageInfo.stageClass, stageInfo.stage, delay ) )
      else:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( "stage-config %s block %s" % (
               stageInfo.stageClass, stageInfo.stage ) )
