# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.MaintenanceModeCliSaveLib import MaintenanceConfigMode
from CliMode.MaintenanceStagesMode import MaintenanceStagesMode
from CliMode.PimMaintenanceMode import PimMaintenanceMode
from CliMode.PimsmMaintenanceMode import PimsmMaintenanceMode
from Toggles.StageMgrToggleLib import togglePimMaintenanceModeEnabled

class MaintenanceStagesConfigMode( MaintenanceStagesMode, CliSave.Mode ):
   def __init__( self, param ):
      MaintenanceStagesMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class PimMaintenanceConfigMode( PimMaintenanceMode, CliSave.Mode ):
   def __init__( self, param ):
      PimMaintenanceMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class PimsmMaintenanceConfigMode( PimsmMaintenanceMode, CliSave.Mode ):
   def __init__( self, param ):
      PimsmMaintenanceMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

MaintenanceConfigMode.addChildMode( MaintenanceStagesConfigMode )
MaintenanceStagesConfigMode.addChildMode( PimMaintenanceConfigMode )
PimMaintenanceConfigMode.addChildMode( PimsmMaintenanceConfigMode )
PimsmMaintenanceConfigMode.addCommandSequence( 'Pimsm' )

@CliSave.saver( 'Maintenance::PimStageConfig', 'maintenance/pimStageConfig',
                requireMounts=( 'maintenance/runnability/config', ) )
def savePimConfig( entity, root, requireMounts, options ):
   if not "enabled" in requireMounts[ 'maintenance/runnability/config' ]:
      return
   if togglePimMaintenanceModeEnabled():
      mode = root[ MaintenanceConfigMode ].getSingletonInstance()
      stagesMode = mode[ MaintenanceStagesConfigMode ].getSingletonInstance()
      pimMode = stagesMode[ PimMaintenanceConfigMode ].getSingletonInstance()
      if entity.sparseModeIpv4Enabled or entity.sparseModeIpv6Enabled:
         pimsmMode = pimMode[ PimsmMaintenanceConfigMode ].getSingletonInstance()
         cmds = pimsmMode[ 'Pimsm' ]
         if ( entity.interval != entity.defaultInterval or options.saveAll
               or options.saveAllDetail ):
            cmds.addCommand( f'interval {int(entity.interval)}' )
         if entity.sparseModeIpv4Enabled:
            cmds.addCommand( "ipv4" )
         else:
            cmds.addCommand( "no ipv4" )
         if entity.sparseModeIpv6Enabled:
            cmds.addCommand( "ipv6" )
         else:
            cmds.addCommand( "no ipv6" )
