#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.StunCliMode import  StunClientBaseMode
from CliSavePlugin.StunServerCliSave import StunCliSaveMode
from CliSavePlugin.IntfCliSave import IntfConfigMode

CliSave.GlobalConfigMode.addChildMode( StunCliSaveMode,
                                       after=[ IntfConfigMode ] )

class StunClientCliSaveMode( StunClientBaseMode, CliSave.Mode ):
   def __init__( self, param ):
      StunClientBaseMode.__init__( self )
      CliSave.Mode.__init__( self, param )

StunCliSaveMode.addChildMode( StunClientCliSaveMode )

def isClientConfigDefault( stunClientConfig ):
   return (
      stunClientConfig.disabled == stunClientConfig.disabledDefault  and
      stunClientConfig.refreshInterval == stunClientConfig.refreshIntervalDefault )

@CliSave.saver( 'Stun::ClientCliConfig', 'stun/client/cliConfig' )
def saveStunClientConfig( stunClientConfig, root, requireMounts, options ):

   # We shouldn't save any command if all the attributes in the config are set to the
   # default values and 'show running-config' wasn't called with saveAll or
   # saveAllDetail option
   if ( not ( options.saveAll or options.saveAllDetail ) and
        isClientConfigDefault( stunClientConfig ) ):
      return

   stunMode = root[ StunCliSaveMode ].getSingletonInstance()
   stunClientMode = stunMode[ StunClientCliSaveMode ].getSingletonInstance()
   cmds = stunClientMode[ 'Stun.clientConfig' ]


   if stunClientConfig.disabled:
      cmds.addCommand( "disabled" )
   elif options.saveAll or options.saveAllDetail:
      #Display default
      cmds.addCommand( "no disabled" )

   if stunClientConfig.refreshInterval != stunClientConfig.refreshIntervalDefault:
      cmds.addCommand( "refresh interval %d seconds" %
                       int( stunClientConfig.refreshInterval ) )
   elif options.saveAll:
      cmds.addCommand( "refresh interval %d seconds" %
                       stunClientConfig.refreshIntervalDefault )

StunClientCliSaveMode.addCommandSequence( 'Stun.clientConfig' )
