# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

from CliSavePlugin.Controllerdb import ( CvxConfigMode,
                                         controllerConfigPath,
                                         getClusterName )
from CliMode.Topology import TopologyMode

#------------------------------------------------------------------------------
# Topology Mode Saver
#------------------------------------------------------------------------------

class TopologyConfigSaveMode( TopologyMode, CliSave.Mode ):
   def __init__( self, param ):
      TopologyMode.__init__( self )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode( TopologyConfigSaveMode,
                            after=[ 'cvx' ] )

TopologyConfigSaveMode.addCommandSequence( 'topology.config' )

def saveTopologyAggConfigCommon( entity, root, requireMounts, options,
                                 commentKey ):
   cmds = []
   staticEdgeCmd = 'network physical-topology switch %s interface %s neighbor %s'
   # need to sort manually until TACC supports ordered sets
   for edge in sorted( entity.staticEdge ):
      cmd = staticEdgeCmd % ( edge.fromHost, edge.fromPort, edge.toHost )
      if edge.toPort != "":
         # pylint: disable-next=consider-using-f-string
         cmd += ' neighbor-interface %s' % edge.toPort
      cmds.append( cmd )

   if cmds or CliSave.hasComments( commentKey, requireMounts ):
      clusterName = getClusterName( requireMounts[ controllerConfigPath ] )
      cvxMode = root[ CvxConfigMode ].getOrCreateModeInstance(
         CvxConfigMode.modeName( clusterName ) )
      topologyMode = cvxMode[ TopologyConfigSaveMode ].getOrCreateModeInstance(
            'cvx-topology' )
      cmdSeq = topologyMode[ 'topology.config' ]

      for cmd in cmds:
         cmdSeq.addCommand( cmd )

@CliSave.saver( 'NetworkTopologyAggregatorV3::Config',
                'topology/aggregator/config',
                requireMounts=( controllerConfigPath, 'cli/config' ) )
def saveTopologyAggConfig( entity, root, requireMounts, options ):
   saveTopologyAggConfigCommon( entity, root, requireMounts, options,
                                'cvx-topology' )
