#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Traceroute.config' )

@CliSave.saver( 'Mgmt::Traceroute::Config', 'mgmt/traceroute/config' )
def saveTracerouteDscp( tracerouteConfig, root, requireMounts, options ):

   cmds = root[ 'Traceroute.config' ]
   if tracerouteConfig.dscpValue:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( "traceroute qos dscp %d" % tracerouteConfig.dscpValue )
   elif options.saveAll:
      cmds.addCommand( "no traceroute qos dscp" )
