#!/usr/bin/env python3
# Copyright (c) 2009, 2010, 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSaveBlock import SensitiveCommand
import ReversibleSecretCli
from CliSavePlugin.Security import mgmtSecurityConfigPath
from CliSavePlugin.IntfCliSave import IntfConfigMode
from CliMode.VmTracer import VCenterMode
from CliMode.VmTracer import VShieldMode
from IpLibConsts import DEFAULT_VRF

class VShieldConfigMode( VShieldMode, CliSave.Mode ):
   def __init__( self, param ):
      VShieldMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

VShieldConfigMode.addCommandSequence( 'VmTracer.vShield' )

class VCenterConfigMode( VCenterMode, CliSave.Mode ):
   def __init__( self, param ):
      VCenterMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( VCenterConfigMode, 
                                       after=[ IntfConfigMode ] )
VCenterConfigMode.addCommandSequence( 'VmTracer.vCenter' )
VCenterConfigMode.addChildMode( VShieldConfigMode,
                                after=[ 'VmTracer.vCenter' ] )

@CliSave.saver( 'VmwareVI::ViConfig', 'vmtracer/config/session', 
                requireMounts = ( mgmtSecurityConfigPath, ) )
def saveVmTracerViConfig( entity, root, requireMounts, options ):
   sessionDir = entity.parent
   sessionName = sessionDir.name
   mode = root[ VCenterConfigMode ].getOrCreateModeInstance( sessionName )
   cmdSeq = mode[ 'VmTracer.vCenter' ]
   if entity.url:
      # pylint: disable-next=consider-using-f-string
      cmdSeq.addCommand( 'url %s' %( entity.url ) )
   if entity.username != '':
      cmdSeq.addCommand( SensitiveCommand( 'username {}', entity.username ) )
   if entity.password:
      securityConfig = requireMounts[ mgmtSecurityConfigPath ]

      cmd = ReversibleSecretCli.getCliSaveCommand( 'password {}',
                                                   securityConfig,
                                                   entity.password,
                                                   uniqueKey='VmwareVds',
                                                   algorithm='DES' )
      cmdSeq.addCommand( cmd )
   if not entity.autoVlan:
      cmdSeq.addCommand( 'autovlan disable' )
   if entity.allowedVlans != "1-4094":
      if not entity.allowedVlans:
         cmdSeq.addCommand( 'no allowed-vlan' )
      else:
         # pylint: disable-next=consider-using-f-string
         cmdSeq.addCommand( 'allowed-vlan %s' % ( entity.allowedVlans ) )
   if entity.vrf != DEFAULT_VRF:
      # pylint: disable-next=consider-using-f-string
      cmdSeq.addCommand( 'vrf %s' % ( entity.vrf ) )
   if entity.sourceIntf != '':
      if not entity.sourceIntf:
         cmdSeq.addCommand( 'no source-interface' )
      else:
         # pylint: disable-next=consider-using-f-string
         cmdSeq.addCommand( 'source-interface %s' % ( entity.sourceIntf ) )

@CliSave.saver( 'VmwareVI::VsConfig', 'vmtracer/config/session',
                requireMounts = ( mgmtSecurityConfigPath, ) )
def saveVmTracerVsConfig( entity, root, requireMounts, options ):
   sessionDir = entity.parent
   sessionName = sessionDir.name
   mode = root[ VCenterConfigMode ].getOrCreateModeInstance( sessionName )
   mode = mode[ VShieldConfigMode ].getOrCreateModeInstance( sessionName )
   cmdSeq = mode[ 'VmTracer.vShield' ]
   if entity.url:
      # pylint: disable-next=consider-using-f-string
      cmdSeq.addCommand( 'url %s' %( entity.url ) )
   if entity.username != '':
      cmdSeq.addCommand( SensitiveCommand( 'username {}', entity.username ) )
   if entity.password:
      securityConfig = requireMounts[ 'mgmt/security/config' ]
      cmd = ReversibleSecretCli.getCliSaveCommand( 'password {}',
                                                   securityConfig,
                                                   entity.password,
                                                   uniqueKey='VShield',
                                                   algorithm='DES' )
      cmdSeq.addCommand( cmd )
