#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.RouterGeneralCliSave import getRouterGeneralVrfModeCtx
from Toggles import RcfLibToggleLib

@CliSave.saver( 'Routing::VrfLeak::Config', 'routing/vrfleak/config' )
def saveVrfLeakConfig( entity, root, requireMounts, options ):
   for vrfName, vrf in entity.vrf.items():
      assert vrf
      mode = getRouterGeneralVrfModeCtx( root, vrfName )
      cmds = mode[ 'vrfConfig' ]

      for sourceVrf, vlc in vrf.leakFrom.items():
         assert vlc
         if RcfLibToggleLib.toggleRcfLeakRoutesEnabled() and vlc.rcf:
            cmds.addCommand( ( f'leak routes source-vrf {sourceVrf} subscribe rcf'
                               f' {vlc.rcf}()' ) )
         elif vlc.routeMap:
            # pylint: disable-next=consider-using-f-string
            cmds.addCommand( "leak routes source-vrf %s subscribe-policy %s" %
                           ( sourceVrf, vlc.routeMap ) )
