# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.DmfCliSave import DmfConfigMode

@CliSave.saver( 'Ztn::Config', 'ztn/config' )
def saveZtnConfig( config, root, requireMounts, options ):
   # Since all config commands are hidden so far, skip 'saveAll' option
   mode = root[ DmfConfigMode ].getSingletonInstance()
   cmds = mode[ 'Dmf' ]

   if config.sourceIntf:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'source-interface %s' % config.sourceIntf )

   if config.bypassHandshake:
      cmds.addCommand( 'handshake disabled' )

   if config.skipReboot:
      cmds.addCommand( 'handshake reload disabled' )
