#!/usr/bin/env python3
# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file defines the 'clear' token in CLI

import CliMatcher
import CliCommand
from CommonGuards import ssoStandbyGuard

# No clear command on sso/standby since most fail. This is an
# easy thing to do. Are there any clear commands that should
# be enabled?

# EXEC mode
clearKwNode = CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'clear',
                                                        helpdesc='Reset functions' ),
                               guard=ssoStandbyGuard )

# This 'testfile' attribute is used by Eos/test/EosCliTokenTest.py to
# load tests to run as part of autobuild of the Eos package. It should
# also run as a standalone product test.
testfile = 'Cli/CliTokenTest.py'
