# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.IpAddrMatcher as IpAddrMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.Ip6AddrMatcher as Ip6AddrMatcher
from CliPlugin.RouteDistinguisher import RdDistinguisherMatcher
from CliCommand import CliExpression

ruleMatcher = CliMatcher.KeywordMatcher(
      'rule', helpdesc='Flow-spec rule string' )
identifierMatcher = CliMatcher.KeywordMatcher(
      'identifier', helpdesc='Flow-spec rule identifier' )
ruleIdMatcher = CliMatcher.IntegerMatcher(
      1, 0xffffffffffffffff,
      helpdesc='Flow-spec rule identifier' )

destinationMatcher = CliMatcher.KeywordMatcher(
      'destination', helpdesc='Destination prefix' )
sourceMatcher = CliMatcher.KeywordMatcher(
      'source', helpdesc='Source prefix' )

ipv4AddrMatcherForShow = IpAddrMatcher.ipPrefixExpr(
      'Network address', 'Network mask', 'Prefix',
      overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO,
      maskKeyword=False )
ipv6AddrMatcherForShow = Ip6AddrMatcher.Ip6PrefixValidMatcher(
      helpdesc="prefix",
      overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO )
ipv4FlowspecVpnMatcherForShow = CliMatcher.KeywordMatcher(
    'vpn-ipv4', helpdesc='Details related to Flowspec VPN IPv4' )
ipv6FlowspecVpnMatcherForShow = CliMatcher.KeywordMatcher(
    'vpn-ipv6', helpdesc='Details related to Flowspec VPN IPv6' )

class RouteDistinguisherCliExpression( CliExpression ):
   expression = "rd RD_VAL"
   data = {
      'rd' : 'BGP route distinguisher ',
      'RD_VAL' : RdDistinguisherMatcher( helpdesc='BGP route distinguisher ' )
   }

interfaceSetMatcherForShow = CliMatcher.KeywordMatcher(
      'interface-set', helpdesc='Flow-spec interface-set' )

interfaceSetIdMatcher = CliMatcher.IntegerMatcher(
      0, 16383,
      helpdesc='Flow-spec interface-set identifier' )

policyMatcherForShow = CliMatcher.KeywordMatcher(
      'policy', helpdesc='Flow-spec policy name' )
