#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file defines the 'start', 'stop' and 'clear' token in CLI for Eoam generators.
# Currently it is used only for Eoam based features - SAT Link Qualification and
# RFC2544

import CliCommand
from CliMatcher import KeywordMatcher
from CommonGuards import ssoStandbyGuard

# There is no clear command on sso/standby since most fail.
# Following the same reasoning, we are adding ssoStandbyGuard
# for the following tokens too.
startKwForGenerator = CliCommand.Node( matcher=KeywordMatcher(
   'start', helpdesc='Start execution command' ),
   guard=ssoStandbyGuard )
stopKwForGenerator = CliCommand.Node( matcher=KeywordMatcher(
   'stop', helpdesc='Stop execution command' ),
   guard=ssoStandbyGuard )

# This 'testfile' attribute is used by Eos/test/EosCliTokenTest.py to
# load tests to run as part of autobuild of the Eos package. It should
# also run as a standalone product test.
testfile = 'EoamTest/CliTokenTest.py'
