# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMatcher import KeywordMatcher, IntegerMatcher

U32_MAX_VALUE = 0xFFFFFFFF

ipLockingAddressMatcherForConfig = KeywordMatcher(
      'address',
      helpdesc='Global address locking config commands' )

ipLockingLockingMatcherForConfig = KeywordMatcher(
      'locking',
      helpdesc='Enable address locking feature' )

ipLockingAddressMatcherForConfigIf = KeywordMatcher(
      'address',
      helpdesc='Interface address locking config commands' )

ipLockingLockingMatcherForConfigIf = KeywordMatcher(
      'locking',
      helpdesc='Address locking feature' )

ipLockingIpv4MatcherForConfigIf = KeywordMatcher(
      'ipv4',
      helpdesc='Enable address locking for IPv4' )

ipLockingIpv6MatcherForConfigIf = KeywordMatcher(
      'ipv6',
      helpdesc='Enable address locking for IPv6' )

ipLockingIpv4DisableMatcherForConfigIf = KeywordMatcher(
      'ipv4',
      helpdesc='Address locking for IPv4' )

ipLockingIpv6DisableMatcherForConfigIf = KeywordMatcher(
      'ipv6',
      helpdesc='Address locking for IPv6' )

ipLockingVlanMatcherForConfigIf = KeywordMatcher(
      'vlan',
      helpdesc='Override address locking VLAN configuration' )

ipLockingDisabledMatcherForConfigIf = KeywordMatcher(
      'disabled',
      helpdesc='Disable address locking feature' )

ipLockingAddressMatcherForShow = KeywordMatcher(
      'address',
      helpdesc='Global address locking show commands' )

ipLockingLockingMatcherForShow = KeywordMatcher(
      'locking',
      helpdesc='Display IpLocking status' )

ipLockingTableMatcherForShow = KeywordMatcher(
      'table',
      helpdesc='Display address locking table' )

ipLockingIpv4MatcherForShow = KeywordMatcher(
      'ipv4',
      helpdesc='Display the address locking table for IPv4' )

ipLockingIpv6MatcherForShow = KeywordMatcher(
      'ipv6',
      helpdesc='Display the address locking table for IPv6' )

ipLockingStaticMatcherForShow = KeywordMatcher(
      'static',
      helpdesc='Only display the static leases' )

ipLockingDynamicMatcherForShow = KeywordMatcher(
      'dynamic',
      helpdesc='Only display the dynamic leases' )

ipLockingInterfasceMatcherForShow = KeywordMatcher(
      'interface',
      helpdesc='Only display the leases belong to a specified interface' )

ipLockingInstalledMatcherForShow = KeywordMatcher(
      'installed',
      helpdesc='Only display the leases that are installed in hardware' )

ipLockingAddressMatcherForClear = KeywordMatcher(
      'address',
      helpdesc='Address locking information' )

ipLockingLockingMatcherForClear = KeywordMatcher(
      'locking',
      helpdesc='Address locking information' )

ipLockingCountersMatcherForShow = KeywordMatcher(
      'counters',
      helpdesc='Address locking counters' )

ipLockingCountersMatcherForClear = KeywordMatcher(
      'counters',
      helpdesc='Clear address locking counters' )

ipLockingServersMatcherForShow = KeywordMatcher(
      'servers',
      helpdesc='Address locking servers information' )

ipLockingDhcpMatcherForConfig = KeywordMatcher(
      'dhcp',
      helpdesc='Configuration options related to DHCP' )

ipLockingServerMatcherForConfig = KeywordMatcher(
      'server',
      helpdesc='Set DHCP server' )

ipLockingIpv4MatcherForConfig = KeywordMatcher(
      'ipv4',
      helpdesc='Specify IPv4 DHCP server' )

ipLockingIpv6MatcherForConfig = KeywordMatcher(
      'ipv6',
      helpdesc='Specify IPv6 DHCP server' )

ipLockingProtocolMatcherForConfig = KeywordMatcher(
      'protocol',
      helpdesc='Query protocol' )

ipLockingAristaQueryMatcherForConfig = KeywordMatcher(
      'arista-query',
      helpdesc='Arista IP Query protocol' )

ipLockingleaseMatcherForConfig = KeywordMatcher(
      'lease',
      helpdesc='Configure lease' )

ipLockingQueryMatcherForConfig = KeywordMatcher(
      'query',
      helpdesc='Configure lease query retry interval and timeout' )

ipLockingRetryMatcherForConfig = KeywordMatcher(
      'retry',
      helpdesc='Configure retry interval' )

ipLockingIntervalMatcherForConfig = KeywordMatcher(
      'interval',
      helpdesc='Configure retry interval' )

ipLockingRetryIntervalValueMatcherForConfig = IntegerMatcher(
      1,
      U32_MAX_VALUE,
      helpdesc='Specify Retry Interval Time' )

ipLockingTimeoutMatcherForConfig = KeywordMatcher(
      'timeout',
      helpdesc='Configure timeout' )

ipLockingTimeoutValueMatcherForConfig = IntegerMatcher(
      1,
      U32_MAX_VALUE,
      helpdesc='Specify timeout' )

matcherLockedAddr = KeywordMatcher(
      'locked-address',
      helpdesc='Configuration options for locked addresses' )

matcherLockedAddrDisable = KeywordMatcher(
      'disabled',
      helpdesc='Disable enforcement for locked addresses' )

matcherLockedAddrEnforcement = KeywordMatcher(
      'enforcement',
      helpdesc='Configure enforcement for locked addresses' )

ipLockingDenyMatcherForShow = KeywordMatcher(
      'deny',
      helpdesc='Only display denied addresses/leases' )

ipLockingPermitMatcherForShow = KeywordMatcher(
      'permit',
      helpdesc='Only display permitted addresses/leases' )
