# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This module is intended to keep common tokens that may be shared across several
# commands with the new CLI parser.

from CliPlugin.TunnelRibCli import (
   systemTunnelRibName,
   systemColoredTunnelRibName,
)
from CliMatcher import KeywordMatcher

matcherColoredTunnelRib = \
      KeywordMatcher( 'colored',
                      helpdesc='Resolve using a named colored tunnel RIB' )
matcherSystemColoredTunnelRib = \
      KeywordMatcher( systemColoredTunnelRibName,
                      helpdesc='The system colored tunnel RIB' )
matcherSystemTunnelRib = KeywordMatcher( systemTunnelRibName,
                                         helpdesc='The system tunnel RIB' )
matcherTunnelRib = KeywordMatcher( 'tunnel-rib',
                                   helpdesc='Resolve using a named tunnel RIB' )
matcherResolution = KeywordMatcher( 'resolution',
                                    helpdesc='Next-hop resolution policy' )
matcherRibs = KeywordMatcher( 'ribs',
                              helpdesc='Resolving RIBs in order of preference' )
matcherSystemDefault = KeywordMatcher( 'system-default',
                                       helpdesc='Resolve using the default '
                                       'resolution profile for a route\'s next-hop' )
