#!/usr/bin/env python3
# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file defines the 'ipv4' token in CLI

from CliMatcher import KeywordMatcher

# Global config mode
ipv4MatcherForConfig = KeywordMatcher( 'ipv4',
                             helpdesc='Global IPv4 configuration commands' )
# Interface config mode
ipv4MatcherForConfigIf = KeywordMatcher( 'ipv4',
                               helpdesc='Interface IPv4 config commands' )
# Router mode
ipv4MatcherForConfigRouter = KeywordMatcher( 'ipv4',
                                   helpdesc='IPv4 configuration commands '
                                            'for Routing protocols' )
# Config-cp mode
ipv4MatcherForConfigCp = KeywordMatcher( 'ipv4',
                               helpdesc='Control plane IPv4 configuration' )
# 'clear ip'
ipv4MatcherForClear = KeywordMatcher( 'ipv4', helpdesc='Clear IPv4 information' )
# 'show ip'
ipv4MatcherForShow = KeywordMatcher( 'ipv4', helpdesc='Details related to IPv4' )
# 'refresh ip'
ipv4MatcherForRefresh = KeywordMatcher( 'ipv4', helpdesc='Refresh IPv4 information' )
