#!/usr/bin/env python3
# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file defines the 'ipv6' token in CLI

from CliMatcher import KeywordMatcher

# Global config mode
ipv6MatcherForConfig = KeywordMatcher( 'ipv6',
                                       helpdesc='Configuration for IPv6' )
# Interface config mode
ipv6MatcherForConfigIf = KeywordMatcher( 'ipv6',
                                         helpdesc='Interface IPv6 config commands' )
# Router mode
ipv6MatcherForConfigRouter = KeywordMatcher( 'ipv6',
                                             helpdesc='IPv6 configuration commands '
                                                      'for Routing protocols' )
# Config-cp mode
ipv6MatcherForConfigCp = KeywordMatcher( 'ipv6',
                                         helpdesc='Control plane IPv6 '
                                                  'configuration' )
# 'clear ip'
ipv6MatcherForClear = KeywordMatcher( 'ipv6',
                                      helpdesc='Clear IPv6 information' )
# 'show ip'
ipv6MatcherForShow = KeywordMatcher( 'ipv6',
                                     helpdesc='Details related to IPv6' )
# 'refresh ip'
ipv6MatcherForRefresh = KeywordMatcher( 'ipv6',
                                        helpdesc='Refresh IPv6 information' )
