# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import IpAddrMatcher, Ip6AddrMatcher
from CliPlugin.AclCli import AclNameMatcher
from CliPlugin.VrfCli import getVrfNames
from McastCommonCliLib  import mcastRoutingSupportedGuard
from McastCommonCliLib  import mcastGenRoutingSupportedGuard
from McastCommonCliLib  import mcastGenRoutingSupportedIntfGuard
from CliMatcher import ( KeywordMatcher, IntegerMatcher,
                         EnumMatcher, DynamicNameMatcher )
from CliCommand import Node, guardedKeyword

pimNode = Node(
      KeywordMatcher( 'pim', helpdesc='Protocol Independent Multicast (PIM)' ),
      guard=mcastGenRoutingSupportedGuard )

pimMatcherForShow = KeywordMatcher( 'pim', helpdesc='PIM information' )

pimNodeAfterShow = Node(
      pimMatcherForShow,
      guard=mcastGenRoutingSupportedGuard )

pimNodeAfterShowIp = Node(
      pimMatcherForShow,
      guard=mcastRoutingSupportedGuard )

pimNodeAfterClear = Node(
      KeywordMatcher( 'pim', helpdesc='Clear PIM information' ),
      guard=mcastGenRoutingSupportedGuard )

pimMatcherForIntfConfig = Node(
      KeywordMatcher( 'pim', helpdesc='Protocol Independent Multicast (PIM)' ),
      guard=mcastGenRoutingSupportedIntfGuard )

bidirMatcher = KeywordMatcher( 'bidirectional', helpdesc='Bidirectional PIM' )

sparseModeMatcher = KeywordMatcher( 'sparse-mode', helpdesc='Sparse mode PIM' )

protocolMatcher = KeywordMatcher( 'protocol',
      helpdesc='Detailed protocol information' )

countersMatcher = KeywordMatcher( 'counters', helpdesc='PIM counters' )

algorithmMatcher = KeywordMatcher( 'algorithm',
                                    helpdesc='Rendezvous point hashing algorithm' )

moduloMatcher = KeywordMatcher( 'modulo',
                              helpdesc='Rendezvous Point hashing algorithm modulo' )
fastRerouteMatcher = KeywordMatcher( 'fast-reroute',
      helpdesc='Multicast Only Fast Reroute' )
mrouteMatcher = guardedKeyword( 'mroute',
      helpdesc='PIM routing information',
      guard=mcastRoutingSupportedGuard )
routeMatcher = KeywordMatcher( 'route',
      helpdesc='PIM routing information' )
ssmMatcher = KeywordMatcher( 'ssm',
      helpdesc='Source-Specific Multicast options' )
ssmRangeMatcher = KeywordMatcher( 'range',
      helpdesc='Source-Specific Multicast range' )
thresholdMatcher = EnumMatcher( {
   '0': 'Immediately switch',
   'infinity': 'Never switch',
} )

rpAddressMatcher = KeywordMatcher( 'rp-address', helpdesc='Rendezvous point' )

rpAddrValueMatcher = IpAddrMatcher.IpAddrMatcher( 'Rendezvous point IP address' )

rpAddr6ValueMatcher = Ip6AddrMatcher.Ip6AddrMatcher( 
      'Rendezvous point IPv6 address' )

groupRangeMatcher = IpAddrMatcher.ipPrefixExpr( 'Group range prefix',
      'Group range prefix mask', 'Group address range with prefix',
      partial=True, returnError='PimCli::Error' )

groupRange6Matcher = Ip6AddrMatcher.Ip6PrefixValidMatcher( 'IPv6 address prefix' )

hashmaskMatcher = KeywordMatcher( 'hashmask',
      helpdesc='The length (in bits) of the mask to use in the hash function' )

hashValueMatcher = IntegerMatcher( 0, 32,
      helpdesc='The length of mask to use in the hash function' )

hashValueMatcher6 = IntegerMatcher( 0, 128,
      helpdesc='The length of mask to use in the hash function' )

priorityMatcher = KeywordMatcher( 'priority',
      helpdesc='Priority value used in RP advertisement' )

priorityValueMatcher = IntegerMatcher( 0, 255,
      helpdesc='Priority value used in RP advertisement '
               '(0 is the highest priority)' )
accessListMatcher = KeywordMatcher( 'access-list',
      helpdesc='Group access list name' )

excludes = [ 'override', 'hashmask', 'priority' ]
aclNameMatcher = AclNameMatcher( excludeKeywords=excludes )

overrideMatcher = KeywordMatcher( 'override',
      helpdesc='Override dynamic bootstrap router learned mappings '
               'for this group/prefix' )

rpMatcher = KeywordMatcher( 'rp', helpdesc='Rendezvous point' )

rpHashMatcher = KeywordMatcher( 'rp-hash', helpdesc='RP Hashing' )

groupMatcher = IpAddrMatcher.IpAddrMatcher( 'Multicast group address' )

detailMatcher = KeywordMatcher( 'detail', helpdesc='Details' )

upstreamMatcher = KeywordMatcher( 'upstream',
      helpdesc='Information about messages sent upstream' )

joinsMatcher = KeywordMatcher( 'joins',
      helpdesc='Show join/prune messages sent upstream' )

joinMatcher = KeywordMatcher( 'join',
      helpdesc='Show periodic upstream join/prune messages' )

neighborsMatcher = KeywordMatcher( 'neighbor',
      helpdesc="Show join/prune messages sent to a specific neighbor" )

joinsNeighborAddrMatcher = IpAddrMatcher.IpAddrMatcher( 
      'IP address of neighbor' )

allowMatcher = KeywordMatcher( 'allow',
      helpdesc='allows (*,G)s from RPs other than those defined.' )

mrouteInterfaceMatcherForShow = KeywordMatcher( 'interface',
      helpdesc='Route interface specific state' )

mrouteCountMatcher = KeywordMatcher( 'count',
      helpdesc='Count of multicast routes' )

vrfMatcher = KeywordMatcher( 'vrf',
      helpdesc='VRF name' )
vrfNameMatcher = DynamicNameMatcher( getVrfNames,
      'VRF name' )

configSanityMatcher = KeywordMatcher( 'config-sanity',
      helpdesc='Show hints of potential PIM problems' )
