#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMatcher import KeywordMatcher

serviceKw = KeywordMatcher( 'service',
                       helpdesc='Configure service parameters' )
serviceMatcherForConfig = serviceKw

configKwAfterService = KeywordMatcher(
   'configuration', helpdesc='Configuration settings',
   # this is for backward compatibility
   alternates=( 'config', ) )
configMatcherForAfterService = configKwAfterService

# This 'testfile' attribute is used by Eos/test/EosCliTokenTest.py to
# load tests to run as part of autobuild of the Eos package. It should
# also run as a standalone product test.
testfile = 'Cli/CliTokenTest.py'
