#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType
from CliCommand import Node
from CliMatcher import (
   KeywordMatcher,
   IntegerMatcher,
   DynamicNameMatcher,
)
from CliPlugin.IpAddrMatcher import IpAddrMatcher

nodeSrcIp = Node( matcher=KeywordMatcher( 'src-ip', "Flow source IP address" ),
                  maxMatches=1 )
nodeIPv4 = Node( matcher=IpAddrMatcher( helpdesc='IPv4 address' ),
                 maxMatches=1 )
nodeDstIp = Node( matcher=KeywordMatcher( 'dst-ip', "Flow destination IP address" ),
                  maxMatches=1 )
nodeSrcPort = Node( matcher=KeywordMatcher( 'src-port', "Flow source port" ),
                    maxMatches=1 )
nodePort = Node( matcher=IntegerMatcher( 0, 65535, helpdesc='IP port' ),
                 maxMatches=1 )
nodeDstPort = Node( matcher=KeywordMatcher( 'dst-port', "Flow destination port" ),
                    maxMatches=1 )

IpProtoType = TacLazyType( 'Arnet::IpProtocolNumber' )
protocols = [ ( p[ len( 'ipProto' ) : ] if p.startswith( 'ipProto' ) else p )
              for p in IpProtoType.attributes ]
nodeProtocol = Node( matcher=KeywordMatcher( 'protocol', "Flow IP protocol" ),
                     maxMatches=1 )
nodeProtocolValue = Node( matcher=DynamicNameMatcher( lambda mode: protocols,
                                                      "IP protocol",
                                                      passContext=True ),
                                                      maxMatches=1 )
nodeDetail = Node( matcher=KeywordMatcher( 'detail',
                                                      "Detailed flow information" ),
                                                      maxMatches=1 )
