#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMatcher import KeywordMatcher
from CliPlugin import (
   IpAddrMatcher,
   IpGenAddrMatcher
)

ldpKw = KeywordMatcher( 'ldp', helpdesc='Label Distribution Protocol' )
mldpKw = KeywordMatcher( 'mldp', helpdesc='Multicast Label Distribution Protocol' )
rsvpKw = KeywordMatcher( 'rsvp', helpdesc='Resource Reservation Protocol' )
tilfaKw = KeywordMatcher( 'ti-lfa', helpdesc='Topology Independent LFA' )
bgpKw = KeywordMatcher( 'bgp', helpdesc='Border Gateway Protocol' )
labeledUnicastKw = KeywordMatcher( 'labeled-unicast', helpdesc='Labeled Unicast' )
forwardingKw = KeywordMatcher( 'forwarding', helpdesc='Forwarding path' )
staticKw = KeywordMatcher( 'static', helpdesc='Static configuration' )
mplsKw = KeywordMatcher( 'mpls', helpdesc='MultiProtocol Label-Switching' )
ipinipKw = KeywordMatcher( 'ip-in-ip', helpdesc='IP-in-IP' )
isisKw = KeywordMatcher( 'isis',
                         helpdesc='Intermediate System to Intermediate System' )
ospfKw = KeywordMatcher( 'ospf', helpdesc='OSPF protocol' )
udpKw = KeywordMatcher( "udp", helpdesc="UDP" )
segmentRoutingKw = KeywordMatcher( 'segment-routing',
                                   helpdesc='Segment routing' )
trafficEngineeringKw = KeywordMatcher( 'traffic-engineering',
                                       helpdesc='Traffic engineering' )
policyKw = KeywordMatcher( 'policy', helpdesc='Policy based' )
voqKw = KeywordMatcher( 'voq', helpdesc='Virtual output queue' )
fabricKw = KeywordMatcher( 'fabric', helpdesc='VOQ fabric' )

tokenTunnelMatcher = KeywordMatcher( 'tunnel', helpdesc="Show tunnel information" )
countersAfterTunnelNode = KeywordMatcher(
   'counters', helpdesc='Tunnel egress hardware counters' )
indexMatcher = KeywordMatcher( 'index', helpdesc='Match tunnel index' )
endpointMatcher = KeywordMatcher( 'endpoint', helpdesc='Match tunnel endpoint' )
tunnelEndpointMatcher = IpGenAddrMatcher.IpGenAddrOrPrefixExprFactory(
   ipOverlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO,
   ip6Overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO,
   allowAddr=True )
nexthopMatcher = KeywordMatcher( 'nexthop', helpdesc='Match tunnel nexthop' )
nhStr = "Address of the nexthop router"
nexthopValMatcher = IpGenAddrMatcher.IpGenAddrMatcher( nhStr )
interfaceMatcher = KeywordMatcher( 'interface', helpdesc='Match tunnel interface' )
tableOutputMatcher = KeywordMatcher( 'table-output',
                                     helpdesc='Provide results in a table format' )
