#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file defines the 'verify' token in CLI

from CliMatcher import KeywordMatcher

verifyMatcherForConfig = KeywordMatcher( 'verify',
                                    helpdesc='Configure source verification method' )
verifyMatcherForConfigIf = verifyMatcherForConfig

verifyMatcherForShow = KeywordMatcher( 'verify',
                                       helpdesc='Show source verification' )

# This 'testfile' attribute is used by Eos/test/EosCliTokenTest.py to
# load tests to run as part of autobuild of the Eos package. It should
# also run as a standalone product test.
testfile = 'IraTest/CliTokenTest.py'
