#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import os
import sys
import subprocess
import ManagedSubprocess

def setDefaultArgs( func ):
   def inner( *args, **kwargs ):
      # Enforce stdout and stderr unless specified
      if kwargs.get( 'input' ) is None:
         kwargs.setdefault( 'stdin', sys.stdin )
      kwargs.setdefault( 'stdout', sys.stdout )
      kwargs.setdefault( 'stderr', sys.stderr )
      return func( *args, **kwargs )
   return inner

class CmdExtension:
   # wrappers for some launchers
   @setDefaultArgs
   def runCmd( self, execCmd, session, **kwargs ):
      return Tac.run( execCmd, **kwargs )

   @setDefaultArgs
   def subprocessPopen( self, execCmd, session, **kwargs ):
      return subprocess.Popen( execCmd, **kwargs )

   @setDefaultArgs
   def managedSubprocessPopen( self, execCmd, session, **kwargs ):
      return ManagedSubprocess.Popen( execCmd, **kwargs )

   @setDefaultArgs
   def system( self, execCmd, session, **kwargs ):
      return os.system( execCmd )

   @setDefaultArgs
   def extendCmd( self, execCmd, session, **kwargs ):
      return True

cmdExt = None

def addCmdExtender( extender ):
   global cmdExt
   if extender:
      cmdExt = extender
   else:
      cmdExt = CmdExtension()

def getCmdExtender():
   global cmdExt
   if cmdExt is None:
      cmdExt = CmdExtension()
   return cmdExt
