#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import CliPlugin.AclCli as AclCli # pylint: disable=consider-using-from-import
import Tac
import Tracing

t0 = Tracing.trace0

aclConfigAggregatorSm = None
aclCpConfigAggregatorSm = None

def initAclConfigAggregatorSm( cliConfig, cliCpConfig, aclConfigDir,
                               aclCpConfigDir ):
   # Some tests (e.g. ShowTechCliTests) don't load all CliPlugins. In those cases,
   # loading this ConfigAgentPlugin is not needed either, so creating the SMs below
   # can be skipped. Be lenient in case we cannot fetch config or cpConfig if we're
   # running btests.
   if not AclCli.config or not AclCli.cpConfig and os.environ.get( 'A4_CHROOT' ):
      t0( "Skipping initAclConfigAggregatorSm, config and cpConfig not present" )
      return
   assert AclCli.config and AclCli.cpConfig, ( "Failed loading ConfigAgentPlugin: "
         "config and cpConfig must be defined" )
   global aclConfigAggregatorSm, aclCpConfigAggregatorSm
   aclConfigAggregatorSm = Tac.newInstance( "Acl::AclConfigAggregatorSm",
                                            aclConfigDir,
                                            cliConfig,
                                            AclCli.config )
   aclCpConfigAggregatorSm = Tac.newInstance( "Acl::AclCpConfigAggregatorSm",
                                              aclCpConfigDir,
                                              cliCpConfig,
                                              AclCli.cpConfig )

class AclSmStarter:
   def __init__( self, em, mg, agent ):
      self.em_ = em
      self.agent_ = agent
      self.cliConfig_ = None
      self.aclConfigDir_ = None
      self.aclCpConfigDir_ = None
      self.doMounts( mg )

   def doMounts( self, mg ):
      self.cliConfig_ = mg.mount( "acl/config/cli", "Acl::Input::Config", "w" )
      self.cliCpConfig_ = mg.mount( "acl/cpconfig/cli", "Acl::Input::CpConfig", "w" )
      self.aclConfigDir_ = mg.mount( "acl/config/input", "Tac::Dir", "ri" )
      self.aclCpConfigDir_ = mg.mount( "acl/cpconfig/input", "Tac::Dir", "ri" )

   def run( self ):
      t0( "Creating AclConfigAggregatorSm and AclCpConfigAggregatorSm" )
      initAclConfigAggregatorSm( self.cliConfig_, self.cliCpConfig_,
                                 self.aclConfigDir_, self.aclCpConfigDir_ )

def Plugin( context ):
   context.registerStateMachine( AclSmStarter )
