# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac 
import Tracing
import AirStreamLib

t0 = Tracing.Handle( "AleCapacityConfigSession" ).trace0

class ToExternalPlatformUtilThresholdSmWrapper(
      AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ 
         ( 'hardware/capacity/config', 'AleCapacity::TableThreshold' ) ]
   externalPathAndType = [
         ( 'hardware/capacity/openconfig/config',
           'AleCapacity::OpenConfig::PlatformUtilizationConfig' ) ]
   smType = 'AleCapacity::OpenConfig::ToExternalPlatformUtilThresholdSm'

   def createSm( self ):
      t0( 'create ToExternalPlatformUtilThresholdSm' )
      self.toExternalSm = Tac.newInstance( self.smType,
            self.nativeEntity(), self.externalEntity() )

def Plugin( context ):
   context.registerStateMachine( ToExternalPlatformUtilThresholdSmWrapper )
