# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
from AirStreamLib import ToExternalSmWrapperBase
from Toggles.BgpCommonToggleLib import (
   toggleOCBgpPolicyDefUniPOAEnabled,
   toggleOCBgpUcmpConfigEnabled,
)

th = Tracing.Handle( "BgpOpenConfig" )
t0 = th.trace0

class ToOCExternalBgpPolicyConfigWrapper( ToExternalSmWrapperBase ):
   nativePathAndType = [ ( "routing/bgp/config", "Routing::Bgp::Config" ),
                         ( "routing/bgp/vrf/config", "Routing::Bgp::VrfConfigDir" ) ]
   externalPathAndType = [
      ( "routing/bgp/openconfig/neighborAfiSafiPolicyConfigDir",
        "Routing::Bgp::OCNeighborAfiSafiPolicyConfigDir" ),
      ( "routing/bgp/openconfig/peerGroupAfiSafiPolicyConfigDir",
        "Routing::Bgp::OCPeerGroupAfiSafiPolicyConfigDir" ) ]
   smType = "Routing::Bgp::OCPolicyConfigSm"

   def createSm( self ):
      t0( "Create ToExternalBgpPolicyConfigWrapper" )
      self.toExternalSm = Tac.newInstance( self.smType,
                                           self.nativeEntity( idx=0 ),
                                           self.nativeEntity( idx=1 ),
                                           self.externalEntity( idx=0 ),
                                           self.externalEntity( idx=1 ) )

class ToOCExternalUcmpConfigWrapper( ToExternalSmWrapperBase ):
   nativePathAndType = [ ( "routing/ucmp/bgp/config",
                           "Routing::Ucmp::UcmpConfig" ),
                         ( "routing/ucmp/bgp/vrf/config",
                           "Routing::Ucmp::VrfUcmpConfigDir" ),
                         ( "routing/bgp/config",
                           "Routing::Bgp::Config" ) ]
   externalPathAndType = [ ( "routing/bgp/openconfig/ucmp",
                             "Routing::Bgp::OpenConfig::OcUcmpRoot" ) ]
   smType = "Routing::Bgp::OpenConfig::OcUcmpConfigSm"

   def createSm( self ):
      t0( "Create ToOCExternalUcmpConfigWrapper" )
      self.toExternalSm = Tac.newInstance( self.smType,
                                           self.nativeEntity( idx=0 ),
                                           self.nativeEntity( idx=1 ),
                                           self.nativeEntity( idx=2 ),
                                           self.externalEntity( idx=0 ) )

def Plugin( context ):
   if toggleOCBgpPolicyDefUniPOAEnabled():
      context.registerStateMachine( ToOCExternalBgpPolicyConfigWrapper )
   
   if toggleOCBgpUcmpConfigEnabled():
      context.registerStateMachine( ToOCExternalUcmpConfigWrapper )
