#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliFragment import ( doMountsInternal,
                          doMountsComplete,
                          fragmentConfig,
                          fragmentStatus,
                          fragmentSessionDir )
from CliFragmentAgent import fragmentMgrEnabled, startFragmentMgrSm
import Tac
import Tracing

t0 = Tracing.trace0

class CliFragmentReactorStarter:
   def __init__( self, em, mg, agent ):
      self.em_ = em
      self.agent_ = agent
      self.fragmentConfig_ = None
      self.fragmentStatus_ = None
      self.fragmentDir_ = None
      self.doMounts( mg )

   def doMounts( self, mg ):
      doMountsInternal( self.em_, mg )

   def run( self ):
      self.fragmentConfig_ = fragmentConfig
      self.fragmentStatus_ = fragmentStatus
      self.fragmentDir_ = fragmentSessionDir
      if fragmentMgrEnabled():
         doMountsComplete( None )
         t0( "Creating FragmentMgr SM" )
         startFragmentMgrSm()

def Plugin( context ):
   context.registerStateMachine( CliFragmentReactorStarter )
