# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import Tac
import Toggles.OpenConfigLibToggleLib

class ToExternalSystemSessionConfigSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ ( 'cli/session/input/config', 'Cli::Session::CliConfig' ),
                         ( 'mgmt/gnmi/config', 'Gnmi::Config' ) ]
   externalPathAndType = [ ( 'openconfig/config/systemSessionConfig',
                            'OpenConfig::SystemSessionConfig' ) ]
   smType = 'OpenConfig::ToExternalSystemSessionConfigSm'

   def createSm( self ):
      self.toExternalSm = Tac.newInstance( self.smType, self.nativeEntity( 0 ),
                                          self.nativeEntity( 1 ),
                                          self.externalEntity() )

def Plugin( context ):
   if Toggles.OpenConfigLibToggleLib.toggleOCSystemSessionConfigEnabled():
      context.registerStateMachine( ToExternalSystemSessionConfigSmWrapper )
