# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import AirStreamLib

t0 = Tracing.Handle( "FieldSetOpenConfig" ).trace0
# Entity Paths
extIpv4EntityPath = "trafficPolicies/openconfig/fieldset/cli/config/ipv4"
extIpv6EntityPath = "trafficPolicies/openconfig/fieldset/cli/config/ipv6"
extPortEntityPath = "trafficPolicies/openconfig/fieldset/cli/config/port"
nativeCliEntityPath = "trafficPolicies/fieldset/input/cli"

class ToExternalFieldSetSyncher( AirStreamLib.ToExternalSmWrapperBase ):
   externalPathAndType = [
      ( extIpv4EntityPath, 'Classification::OcFieldSet::OcIpv4FieldSetConfigDir' ),
      ( extIpv6EntityPath, 'Classification::OcFieldSet::OcIpv6FieldSetConfigDir' ),
      ( extPortEntityPath, 'Classification::OcFieldSet::OcPortFieldSetConfigDir' ) ]
   nativePathAndType = [ ( nativeCliEntityPath, 'Classification::FieldSetConfig' ) ]
   smType = 'Classification::OcFieldSet::ToExternalIpFieldSetSm'

   def createSm( self ):
      t0( 'create ToExternalFieldSetSyncher' )
      self.toExternalSm = Tac.newInstance( self.smType, self.nativeEntity(),
                                           self.externalEntity( 0 ),
                                           self.externalEntity( 1 ),
                                           self.externalEntity( 2 ) )

def Plugin( context ):
   context.registerStateMachine( ToExternalFieldSetSyncher )
