# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import Tac

t0 = Tracing.trace0

class AdminShutdownDelaySm:
   def __init__( self, em, mg, agent ):
      self.em_ = em
      self.agent_ = agent
      self.redundancySm_ = None
      self.redundancyStatus_ = None
      self.redundancyModeActiveConfig_ = None
      self.config_ = None
      self.status_ = None
      self.allIntfConfigDir_ = None
      self.root_ = None
      self.doMounts( mg )

   def doMounts( self, mg ):
      self.config_ = mg.mount( 'goodbye/config',
                               'Goodbye::Config::ConfigDir', 'ri' )
      self.status_ = mg.mount( 'goodbye/status',
                               'Goodbye::Status::StatusDir', 'r' )
      self.redundancyStatus_ = self.agent_.redundancyStatus()

   def run( self ):
      t0( 'GoodbyeSm run' )
      redundancyHelper = 'Goodbye::ConfigAgentPlugin::RedundancyModeActiveHelper'
      redundancyConfig = 'Redundancy::RedundancyModeActiveConfig'
      redundancySm = 'Redundancy::RedundancyModeActiveSm'
      adminShutdownDelay = 'Goodbye::ConfigAgentPlugin::AdminShutdownDelay'

      self.allIntfConfigDir_ = self.em_.getLocalEntity( "interface/config/all" )
      self.root_ = self.em_.root().parent.newEntity( adminShutdownDelay,
                                                     'GoodbyeConfigAgentRoot' )

      helper = Tac.newInstance( redundancyHelper,
                                self.redundancyStatus_,
                                self.root_,
                                self.config_,
                                self.status_,
                                self.allIntfConfigDir_ )
      config = Tac.newInstance( redundancyConfig )
      self.redundancySm_ = Tac.newInstance( redundancySm,
                                            self.redundancyStatus_,
                                            helper,
                                            config )

def Plugin( context ):
   context.registerStateMachine( AdminShutdownDelaySm )

