# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import AirStreamLib

t0 = Tracing.Handle( "MacsecOpenConfig" ).trace0

class ToExternalPolicySmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   # The nativePath is the path to the native entity
   # The smType is the unique string representation of the actual sm
   # These are used to register the sm to StatefulSmManager
   nativePathAndType = [ ( 'macsec/input/cli', 'Macsec::Config' ) ]
   externalPathAndType = [
      ( 'macsec/openconfig/policies', 'Macsec::OCMacsecPolicyDir' ) ]
   smType = 'Macsec::ToExternalMacsecPolicySm'

   def createSm( self ):
      t0( 'create ToExternalPolicySmWrapper' )
      self.toExternalSm = Tac.newInstance( self.smType,
            self.nativeEntity(), self.externalEntity() )

class ToExternalInterfaceSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ ( 'macsec/input/cli', 'Macsec::Config' ) ]
   externalPathAndType = [
      ( 'macsec/openconfig/interfaces', 'Macsec::OCMacsecInterfaceDir' ) ]
   smType = 'Macsec::ToExternalMacsecInterfaceSm'

   def createSm( self ):
      t0( 'create ToExternalMacsecInterfaceSmWrapper' )
      self.toExternalSm = Tac.newInstance( self.smType,
            self.nativeEntity(), self.externalEntity() )

def Plugin( context ):
   context.registerStateMachine( ToExternalPolicySmWrapper )
   context.registerStateMachine( ToExternalInterfaceSmWrapper )
