# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import AirStreamLib
from TypeFuture import TacLazyType
from Toggles.MplsToggleLib import toggleStaticMplsPopOCEnabled

t0 = Tracing.Handle( "MplsOpenConfig" ).trace0

StartupConfigStatus = TacLazyType( 'Sysdb::StartupConfigStatus' )

class StartupConfigStatusSm( Tac.Notifiee ):
   notifierTypeName = 'Sysdb::Status'

   def __init__( self, func, sysdbStatus, *args, **kwargs ):
      super().__init__( sysdbStatus, *args, **kwargs )
      self.func = func
      self.sysdbStatus = sysdbStatus

   @Tac.handler( 'startupConfigStatus' )
   def handleStartupConfigStatus( self ):
      self.func()

class ToExternalStaticMplsSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   # The nativePath is the path to the native entity
   # The smType is the unique string representation of the actual sm
   # These are used to register the sm to StatefulSmManager
   nativePathAndType = [ ( 'routing/mpls/route/input/cli',
                           'Mpls::RouteConfigInput' ),
                         ( "Sysdb/status", "Sysdb::Status" ) ]
   externalPathAndType = [ ( 'routing/mpls/openconfig/staticLsps',
                             'Mpls::OCMplsStaticLspDir' ) ]
   smType = 'Mpls::ToExternalStaticMplsSm'

   def __init__( self, em, mg, agent ):
      self.startupConfigStatusSm = None
      self.sysdbStatus = None
      super().__init__( em, mg, agent )

   def createSm( self ):
      t0( "createSm called for ToExternalStaticSM" )
      self.sysdbStatus = self.mountedEntities_.get(
            self.nativePathAndType[ 1 ][ 0 ] )
      # delay creation of SM until Sysdb reload is complete
      if self.sysdbStatus.startupConfigStatus not in ( StartupConfigStatus.completed,
            StartupConfigStatus.noScriptSpecified ):
         self.startupConfigStatusSm = StartupConfigStatusSm( self.createSm,
                                                             self.sysdbStatus )
      elif not self.toExternalSm:
         t0( "create ToExternalStaticMplsSmWrapper" )
         self.toExternalSm = Tac.newInstance( self.smType,
            self.nativeEntity(), self.externalEntity() )
         if self.startupConfigStatusSm:
            # We deferred creation of toExternalSm, so register it now
            self.registerSm( self.toExternalSm )
            self.startupConfigStatusSm = None
            self.sysdbStatus = None

def Plugin( context ):
   if toggleStaticMplsPopOCEnabled():
      context.registerStateMachine( ToExternalStaticMplsSmWrapper )
