# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import Cell
import Tac
import Tracing
import AirStreamLib
from Toggles.RcfLibToggleLib import toggleRcfPolicyDefinitionsEnabled

th = Tracing.Handle( "RcfOpenConfig" )
t0 = th.trace0

class ToOCExternalRcfConfigSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ ( "routing/rcf/config", "Rcf::Config" ),
                         ( Cell.path( "routing/rcf/debugSymbols" ),
                           "Rcf::Debug::Symbols" ) ]
   externalPathAndType = [ ( "routing/rcf/openconfig/rcfDir",
                             "Rcf::OpenConfig::RcfDir" ) ]
   smType = "Rcf::OpenConfig::RcfDirSm"

   def createSm( self ):
      t0( "Create ToExternalRcfConfigSmWrapper" )
      self.toExternalSm = Tac.newInstance( self.smType,
                                           self.nativeEntity( idx=0 ),
                                           self.nativeEntity( idx=1 ),
                                           self.externalEntity() )

class ToPolicyDefinitionsRcfConfigSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ ( "routing/rcf/config", "Rcf::Config" ),
                         ( Cell.path( "routing/rcf/status" ), "Rcf::Status" )
                        ]
   externalPathAndType = [ ( "routing/policy/openconfig/policyDefinitions",
                             "Routing::Policy::OpenConfig::PolicyDefinitions" ) ]
   smType = "Rcf::OpenConfig::RcfOpenConfigToExternalSm"

   def createSm( self ):
      t0( "Create ToExternalRcfConfigSmWrapper" )
      self.toExternalSm = Tac.newInstance( self.smType,
                                           self.nativeEntity( idx=0 ),
                                           self.nativeEntity( idx=1 ),
                                           self.externalEntity() )

def Plugin( context ):
   # Some of our btests run as cohab CLI tests and create debug symbols without the
   # corresponding RCF config, in which case the SMs registered here do not operate
   # correctly. Since these btests do not care about the operation of these SMs, they
   # can disable the registering of these SMs using the env variable below.
   if not os.environ.get( "DO_NOT_LOAD_RCF_OC_SM" ):
      context.registerStateMachine( ToOCExternalRcfConfigSmWrapper )
      if toggleRcfPolicyDefinitionsEnabled():
         context.registerStateMachine( ToPolicyDefinitionsRcfConfigSmWrapper )
