# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import RouteMapCli
import Tac
import Tracing
import os

t0 = Tracing.trace0

routeMapAggregatorSm = None

class RouteMapSmStarter:
   def __init__( self, em, mg, agent ):
      self.em_ = em
      self.agent_ = agent
      self.cliRmConfig_ = None
      self.inputRmConfigDir_ = None
      self.doMounts( mg )

   def doMounts( self, mg ):
      self.cliRmConfig_ = mg.mount( 'routing/routemap/config',
                                    'Routing::RouteMap::Config', 'w' )
      self.inputRmConfigDir_ = mg.mount( 'routing/routemap/input/config',
                                         'Tac::Dir', 'ri' )

   def run( self ):
      global routeMapAggregatorSm

      if not RouteMapCli.dynamicMapConfig and os.environ.get( 'A4_CHROOT' ):
         t0( 'Skipping creation of routeMapAggregatorSm, not required at this time' )
         return

      assert RouteMapCli.dynamicMapConfig, 'Failed loading ConfigAgentPlugin: ' \
         'dynamicMapConfig must be defined'

      routeMapAggregatorSm = Tac.newInstance(
         'Routing::RouteMap::RouteMapConfigAggregatorSm',
         self.cliRmConfig_, self.inputRmConfigDir_,
         RouteMapCli.dynamicMapConfig )

def Plugin( context ):
   context.registerStateMachine( RouteMapSmStarter )
