# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import AirStreamLib
from Toggles.StpToggleLib import toggleStpOpenConfigEnabled

t0 = Tracing.Handle( "StpOpenConfig" ).trace0

class ToExternalStpModeSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   # nativePath is path where Cli writes to
   # smType represents the sm syncing native Stp mode to external
   # These are used to register the sm to StatefulSmManager
   nativePathAndType = [ ( "stp/input/config/cli", "Stp::Input::Config" ) ]
   externalPathAndType = [ ( "stp/openconfig/globalConfig",
                             "Stp::OCGlobalConfig" ) ]
   smType = "Stp::OCGlobalConfigSm"

   def createSm( self ):
      t0( "create ToExternalStpModeSmWrapper" )
      self.toExternalSm = Tac.newInstance( self.smType, self.nativeEntity(),
                                           self.externalEntity() )

class ToExternalStpInterfaceSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ ( "stp/input/config/cli", "Stp::Input::Config" ),
                         ( "stp/status", "Stp::Status" ) ]
   externalPathAndType = [ ( "stp/openconfig/interfaceConfig",
                             "Stp::OCInterfaceConfigDir" ) ]
   smType = "Stp::OCInterfaceConfigDirSm"

   def createSm( self ):
      t0( "create ToExternalStpInterfaceSmWrapper" )
      self.toExternalSm = Tac.newInstance( self.smType, self.nativeEntity(),
                                           self.nativeEntity( 1 ),
                                           self.externalEntity() )

class ToExternalStpMstSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ ( "stp/input/config/cli", "Stp::Input::Config" ) ]
   externalPathAndType = [ ( "stp/openconfig/mstiConfig",
                             "Stp::OCMstiConfigDir" ) ]
   smType = "Stp::OCMstpConfigWrapperSm"

   def createSm( self ):
      t0( "create ToExternalStpMstSmWrapper" )
      self.toExternalSm = Tac.newInstance( self.smType, self.nativeEntity(),
                                           self.externalEntity() )

def Plugin( context ):
   if toggleStpOpenConfigEnabled():
      context.registerStateMachine( ToExternalStpModeSmWrapper )
      context.registerStateMachine( ToExternalStpInterfaceSmWrapper )
      context.registerStateMachine( ToExternalStpMstSmWrapper )
