# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Tac

def Plugin( entMan ):
   # Custom EntityCopy handlers for Classification types
   fieldSetIpPrefixHandlerDir = CliSession.registerCopyHandlerDir(
      entMan,
      "FieldSetIpPrefixConfig",
      "Classification::FieldSetIpPrefixConfigCopyHandlerDir" )
   fieldSetIpPrefixHandlerDir.copyHandler = ()
   CliSession.registerCustomCopyHandler(
      entMan,
      "",
      "Classification::FieldSetIpPrefixConfig",
      fieldSetIpPrefixHandlerDir.copyHandler )

   fieldSetL4PortHandlerDir = CliSession.registerCopyHandlerDir(
      entMan,
      "FieldSetL4PortConfig",
      "Classification::FieldSetL4PortConfigCopyHandlerDir" )
   fieldSetL4PortHandlerDir.copyHandler = ()
   CliSession.registerCustomCopyHandler(
      entMan,
      "",
      "Classification::FieldSetL4PortConfig",
      fieldSetL4PortHandlerDir.copyHandler )
   config = entMan.lookup( "classification/app-recognition/config" )
   categoryPath = config.fullName + ".category"
   CliSession.registerAttributeEditLogBypass( entMan, categoryPath,
                                              "", "", "del" )
