# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   config = entMan.lookup( "sys/clischeduler/config" )

   # The 'startAt' attribute of System::CliScheduler::ScheduledCli is calculated
   # based on the user config and the current time. Hence, we may get a different
   # 'startAt' value when we execute the same cli scheduler command at
   # a different time. Bypass the debug-attribute check on ScheduledCli.
   # jobsInProgress may get a different value while issuing a Schedule
   # command in past because of similar reason.
   CliSession.registerAttributeEditLogBypass(
      entMan, config.fullName, "scheduledCli",
      "System::CliScheduler::ScheduledCli", "del" )

   CliSession.registerAttributeEditLogBypass(
      entMan, config.fullName, "scheduledCli",
      "System::CliScheduler::ScheduledCli", "set" )

   CliSession.registerAttributeEditLogBypass(
      entMan, config.fullName, "jobsInProgress",
      "U32", "del" )

   CliSession.registerAttributeEditLogBypass(
      entMan, config.fullName, "jobsInProgress",
      "U32", "set" )

