# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import CliSession
import GnmiSetCliSession
import Plugins
import Toggles.OpenConfigLibToggleLib

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):

   class ToNativeConfigDiffConfigSyncher ( GnmiSetCliSession.PreCommitHandler ):
      externalPathList = [ "openconfig/config/systemSessionConfig" ]
      nativePathList = [ "cli/session/input/config", "mgmt/gnmi/config" ]

      @classmethod
      def run( cls, sessionName ):
         externalConfig = AirStreamLib.getSessionEntity(
               entMan, sessionName, "openconfig/config/systemSessionConfig" )
         nativeCliConfig = AirStreamLib.getSessionEntity(
               entMan, sessionName, "cli/session/input/config" )
         nativeGnmiConfig = AirStreamLib.getSessionEntity(
               entMan, sessionName, "mgmt/gnmi/config" )

         nativeGnmiConfig.maxHistorySize = externalConfig.maxHistorySize
         nativeGnmiConfig.saveSessionDiffs = externalConfig.enableDiff
         nativeCliConfig.configTerminalEnabled = externalConfig.enableConfigTerminal

   CliSession.registerConfigGroup( entMan, "airstream-cmv",
      "openconfig/config/systemSessionConfig" )

   if Toggles.OpenConfigLibToggleLib.toggleOCSystemSessionConfigEnabled():
      GnmiSetCliSession.registerPreCommitHandler( ToNativeConfigDiffConfigSyncher )
      AirStreamLib.registerCopyHandler( entMan, "ConfigDiffConfig",
         typeName="OpenConfig::SystemSessionConfig" )
