# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import CliSession
import GnmiSetCliSession
import Plugins
import Tracing

from TypeFuture import TacLazyType

traceHandle = Tracing.Handle( 'ConfigSessionIpv6RouterAdvt' )
t0 = traceHandle.trace0

OcRaIntfErrorType = \
   TacLazyType( 'RouterAdvt::OpenConfig::OcIntfSyncError::ErrorType' )
OcRouterAdvtPreCommitHandler = \
   TacLazyType( 'RouterAdvt::OpenConfig::OcRouterAdvtPreCommitHandler' )

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   class RouterAdvtConfigPreCommitHandler( GnmiSetCliSession.PreCommitHandler ):
      externalPathList = [ 'routing6/routerAdvt/openconfig/config/subIntfConfig',
                           'routing6/routerAdvt/openconfig/config/routedVlanConfig' ]
      nativePathList = [ 'routing6/routerAdvt/config' ]

      @classmethod
      def run( cls, sessionName ):
         raConfig = AirStreamLib.getSessionEntity( entMan, sessionName,
            'routing6/routerAdvt/config' )
         raOcSubIntfConfig = AirStreamLib.getSessionEntity( entMan, sessionName,
            'routing6/routerAdvt/openconfig/config/subIntfConfig' )
         raOcRoutedVlanConfig = AirStreamLib.getSessionEntity( entMan, sessionName,
            'routing6/routerAdvt/openconfig/config/routedVlanConfig' )

         preCommitHandler = OcRouterAdvtPreCommitHandler( raConfig,
               raOcSubIntfConfig, raOcRoutedVlanConfig )
         result = preCommitHandler.validateSubIntfConfig()
         if result.error != OcRaIntfErrorType.intfSyncNoError:
            raise AirStreamLib.ToNativeSyncherError( sessionName, cls.__name__,
                                                     result.message() )

         result = preCommitHandler.validateRoutedVlanConfig()
         if result.error != OcRaIntfErrorType.intfSyncNoError:
            raise AirStreamLib.ToNativeSyncherError( sessionName, cls.__name__,
                                                     result.message() )

         preCommitHandler.syncSubIntfConfig()
         preCommitHandler.syncRoutedVlanConfig()

   CliSession.registerConfigGroup( entMan, 'airstream-cmv',
         'routing6/routerAdvt/openconfig/config/subIntfConfig' )
   CliSession.registerConfigGroup( entMan, 'airstream-cmv',
         'routing6/routerAdvt/openconfig/config/routedVlanConfig' )

   GnmiSetCliSession.registerPreCommitHandler( RouterAdvtConfigPreCommitHandler )
   AirStreamLib.registerCopyHandler( entMan, 'oc-router-advt-subintf',
      path='routing6/routerAdvt/openconfig/config/subIntfConfig' )
   AirStreamLib.registerCopyHandler( entMan, 'oc-router-advt-vlan',
      path='routing6/routerAdvt/openconfig/config/routedVlanConfig' )
