# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   config = entMan.lookup( "routing/isis/config" )
   intfConfigPath = config.fullName + '.intfConfig'
   instanceConfigPath = config.fullName + '.instanceConfig'
   # we need to add the attribute edit log bypass due to the randomness of
   # "SecretCliLib::Secret" attributes salt and initial vector.
   for action in [ "set", "del" ]:
      CliSession.registerAttributeEditLogBypass( entMan, intfConfigPath,
                                       "authKeyColl", "Routing::Isis::AuthKey",
                                       action )
      CliSession.registerAttributeEditLogBypass( entMan, instanceConfigPath,
                                       "authKeyColl", "Routing::Isis::AuthKey",
                                       action )
