# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins
import Tac

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   cliConfigPath = Tac.Type( "Rsvp::RsvpCliConfig" ).mountPath
   # we need to add the attribute edit log bypass due to the randomness of
   # "SecretCliLib::Secret" attributes salt and initial vector.
   cliConfig = entMan.lookup( cliConfigPath )
   CliSession.registerAttributeEditLogBypass( entMan, cliConfig.fullName,
                                              "encodedPassword",
                                              "SecretCliLib::Secret", "del" )
